#Paso 6
library(MASS)
library(lmtest)
library(stepwise)
library(nortest)
library(leaps)
library(relaimpo)
library(boot)
library(mitools)

Datos1 <- Datos[Datos$Regin %in% c("California", "Canarias"), ]
Datos1

#Paso 7
RegModel.1 <- lm(Clorofila.a~Ekman+LnEkman+LnPlataforma+LnTemperatura+LnTurbulencia+Plataforma.continental+Temperatura+Turbulencia, data=Datos1)
summary(RegModel.1)

#Paso 8
summary(stepwise(RegModel.1, direction='forward/backward', criterion='AIC'))

#Paso 9
RegModel.2 <- lm(Clorofila.a~Ekman+Plataforma.continental+Temperatura+Turbulencia, data=Datos1)
summary(RegModel.2)

#Paso 10
RegModel.3 <- lm(LnClorofila.a~Ekman+LnEkman+LnPlataforma+LnTemperatura+LnTurbulencia+Plataforma.continental+Temperatura+Turbulencia, data=Datos1)
summary(stepwise(RegModel.3, direction='forward/backward', criterion='AIC'))

#Paso 11
Modelo.final<- lm(LnClorofila.a~Ekman+Plataforma.continental+Temperatura+Turbulencia, data=Datos1)

#Paso 12
imprel<-calc.relimp(Modelo.final,type=c("lmg","pmvd","last","first"),rela=TRUE)
boot <- boot.relimp(Modelo.final, b = 1000, type = c("lmg", "pmvd", "last", "first"), rank = TRUE, diff = TRUE, rela = TRUE)
booteval.relimp(boot)
x11()
plot(booteval.relimp(boot,sort=TRUE))

#Paso 13
Residuos<-residuals(Modelo.final)
write.csv2(Residuos,file="Salida Cuadro XI.2.csv")

#Paso 14
Shapiro<-shapiro.test(Residuos)
Shapiro
Lillie<-lillie.test(Residuos)
Lillie

#Paso 15
DW<-durbin.watson(Modelo.final)
DW

#Paso 16
BreuschPagan<-bptest(Modelo.final)
BreuschPagan

#Paso 17
VIF<-vif(Modelo.final)
VarInflFact<-paste("Factores de Inflaccin de la Varianza para la estima de la colinealidad")
VIF

#Paso 18
{
 sink("Salida Cuadro XI.2.txt")
 print(summary(Modelo.final))
 print(Shapiro)
 print(Lillie)
 print(BreuschPagan)
 print(DW)
 print(VarInflFact)
 print(VIF)
 sink()
}

